/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.powers;

import com.megacrit.cardcrawl.actions.common.GainBlockAction;
import com.megacrit.cardcrawl.cards.DamageInfo;
import com.megacrit.cardcrawl.core.AbstractCreature;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.helpers.ImageMaster;
import com.megacrit.cardcrawl.localization.PowerStrings;
import com.megacrit.cardcrawl.powers.AbstractPower;

public class MalleablePower
extends AbstractPower {
    public static final String POWER_ID = "Malleable";
    private static final PowerStrings powerStrings = CardCrawlGame.languagePack.getPowerStrings("Malleable");
    public static final String NAME = MalleablePower.powerStrings.NAME;
    public static final String[] DESCRIPTIONS = MalleablePower.powerStrings.DESCRIPTIONS;
    private static final int STARTING_BLOCK = 3;

    public MalleablePower(AbstractCreature owner) {
        this.name = NAME;
        this.ID = POWER_ID;
        this.owner = owner;
        this.amount = 3;
        this.updateDescription();
        this.img = ImageMaster.loadImage("images/powers/32/malleable.png");
    }

    @Override
    public void updateDescription() {
        this.description = DESCRIPTIONS[0] + this.amount + DESCRIPTIONS[1] + NAME + DESCRIPTIONS[2] + 3 + DESCRIPTIONS[3];
    }

    @Override
    public void atEndOfTurn(boolean isPlayer) {
        this.amount = 3;
        this.updateDescription();
    }

    @Override
    public int onAttacked(DamageInfo info, int damageAmount) {
        if (damageAmount < this.owner.currentHealth && damageAmount > 0 && info.owner != null && info.type == DamageInfo.DamageType.NORMAL && info.type != DamageInfo.DamageType.HP_LOSS) {
            this.flash();
            AbstractDungeon.actionManager.addToBottom(new GainBlockAction(this.owner, this.owner, this.amount));
            ++this.amount;
            this.updateDescription();
        }
        return damageAmount;
    }
}

